/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.entity.mobs.pirates.EntityArcherPirate;
import com.minecolonies.coremod.entity.mobs.pirates.EntityCaptainPirate;
import com.minecolonies.coremod.entity.mobs.pirates.EntityPirate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PirateGroundRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation PIRATE_GROUND_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "pirate_ground_raid");

    public PirateGroundRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return PIRATE_GROUND_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.func_186741_a(true);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
    }

    @Override
    public void onFinish() {
        super.onFinish();
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob) || !entity.func_70089_S()) {
            entity.func_70106_y();
            return;
        }
        if (entity instanceof EntityCaptainPirate && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityArcherPirate && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityPirate && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.func_110124_au());
            return;
        }
        entity.func_70106_y();
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob)) {
            return;
        }
        if (entity instanceof EntityCaptainPirate) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherPirate) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityPirate) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static PirateGroundRaidEvent loadFromNBT(IColony colony, CompoundNBT compound) {
        PirateGroundRaidEvent event = new PirateGroundRaidEvent(colony);
        event.deserializeNBT(compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.PIRATE;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.ARCHERPIRATE;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.CHIEFPIRATE;
    }

    @Override
    protected IFormattableTextComponent getDisplayName() {
        return new StringTextComponent(LanguageHandler.format((String)"com.minecolonies.coremod.raid.pirate.name", (Object[])new Object[0]));
    }
}

